/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import java.util.Random;
import lotr.common.LOTRAchievement;
import lotr.common.LOTRMod;
import lotr.common.LOTRPotions;
import lotr.common.entity.ai.LOTREntityAIAttackOnCollide;
import lotr.common.entity.ai.LOTREntityAIFollowHiringPlayer;
import lotr.common.entity.ai.LOTREntityAIHiredRemainStill;
import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.fac.LOTRFaction;
import lotr.common.world.structure.LOTRChestContents;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class LOTREntityBarrowWight
extends LOTREntityNPC {
    private static Potion[] attackEffects = new Potion[]{Potion.field_76421_d, Potion.field_76419_f, Potion.field_82731_v};

    public LOTREntityBarrowWight(World world) {
        super(world);
        this.func_70105_a(0.8f, 2.5f);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new LOTREntityAIHiredRemainStill(this));
        this.field_70714_bg.func_75776_a(2, this.getWightAttackAI());
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new LOTREntityAIFollowHiringPlayer(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 12.0f, 0.02f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, LOTREntityNPC.class, 8.0f, 0.02f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 12.0f, 0.02f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.addTargetTasks(true);
        this.spawnsInDarkness = true;
    }

    public EntityAIBase getWightAttackAI() {
        return new LOTREntityAIAttackOnCollide(this, 1.5, false);
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)-1);
    }

    public int getTargetEntityID() {
        return this.field_70180_af.func_75679_c(16);
    }

    public void setTargetEntityID(Entity entity) {
        this.field_70180_af.func_75692_b(16, (Object)(entity == null ? -1 : entity.func_145782_y()));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(npcAttackDamage).func_111128_a(6.0);
    }

    @Override
    public LOTRFaction getFaction() {
        return LOTRFaction.HOSTILE;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            for (int l = 0; l < 1; ++l) {
                double d = this.field_70165_t + (double)this.field_70130_N * MathHelper.func_82716_a((Random)this.field_70146_Z, (double)-0.5, (double)0.5);
                double d1 = this.field_70163_u + (double)this.field_70131_O * MathHelper.func_82716_a((Random)this.field_70146_Z, (double)0.4, (double)0.8);
                double d2 = this.field_70161_v + (double)this.field_70130_N * MathHelper.func_82716_a((Random)this.field_70146_Z, (double)-0.5, (double)0.5);
                double d3 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)-0.1, (double)0.1);
                double d4 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)-0.2, (double)-0.05);
                double d5 = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)-0.1, (double)0.1);
                if (this.field_70146_Z.nextBoolean()) {
                    LOTRMod.proxy.spawnParticle("morgulPortal", d, d1, d2, d3, d4, d5);
                    continue;
                }
                this.field_70170_p.func_72869_a("smoke", d, d1, d2, d3, d4, d5);
            }
        }
    }

    @Override
    public void func_70624_b(EntityLivingBase target) {
        super.func_70624_b(target);
        if (!this.field_70170_p.field_72995_K) {
            this.setTargetEntityID((Entity)target);
        }
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            int difficulty;
            int duration;
            if (entity instanceof EntityLivingBase && (duration = (difficulty = this.field_70170_p.field_73013_u.func_151525_a()) * (difficulty + 5) / 2) > 0) {
                for (Potion effect : attackEffects) {
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(effect.field_76415_H, duration * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected LOTRAchievement getKillAchievement() {
        return LOTRAchievement.killBarrowWight;
    }

    @Override
    public float getAlignmentBonus() {
        return 0.0f;
    }

    @Override
    protected int func_70693_a(EntityPlayer entityplayer) {
        return 4 + this.field_70146_Z.nextInt(5);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    @Override
    protected void func_70628_a(boolean flag, int i) {
        super.func_70628_a(flag, i);
        int bones = 1 + this.field_70146_Z.nextInt(3) + this.field_70146_Z.nextInt(i + 1);
        for (int l = 0; l < bones; ++l) {
            this.func_145779_a(Items.field_151103_aS, 1);
        }
        if (this.field_70146_Z.nextBoolean()) {
            this.dropChestContents(LOTRChestContents.BARROW_DOWNS, 1, 2 + i + 1);
        }
    }

    @Override
    public boolean canDropRares() {
        return true;
    }

    protected String func_70621_aR() {
        return "lotr:wight.hurt";
    }

    protected String func_70673_aS() {
        return "lotr:wight.death";
    }

    protected void func_145780_a(int i, int j, int k, Block block) {
    }

    @Override
    public boolean func_70601_bi() {
        if (super.func_70601_bi()) {
            if (this.liftSpawnRestrictions) {
                return true;
            }
            int i = MathHelper.func_76128_c((double)this.field_70165_t);
            int j = MathHelper.func_76128_c((double)this.field_70121_D.field_72338_b);
            int k = MathHelper.func_76128_c((double)this.field_70161_v);
            return j > 62 && this.field_70170_p.func_147439_a(i, j - 1, k) == this.field_70170_p.func_72807_a((int)i, (int)k).field_76752_A;
        }
        return false;
    }

    @Override
    public boolean canReEquipHired(int slot, ItemStack itemstack) {
        return false;
    }

    public void func_70690_d(PotionEffect effect) {
        if (effect.func_76456_a() == LOTRPotions.blood.field_76415_H) {
            return;
        }
        super.func_70690_d(effect);
    }
}

